using gov.va.med.vbecs.BOL;
using System;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>10/20/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Criteria collection dialog for inappropriate request report.</summary>
	public class DlgInappropriateRequestReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private const int ReportPageCountWarningThreshold = 50;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picReportLogo;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.ComponentModel.IContainer components = null;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		BOL.InappropriateTransfusionRequestReport _report = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgInappropriateRequestReportCriteria() : 
			base() 
		{
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			//CR 3050 redesigned entire form.
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC096.DlgInappropriateRequestReportCriteria());
			this.GetReportObject();
#if !DESIGN
			
			dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.SetThisToolTip( btnCancel, Common.StrRes.Tooltips.Common.Cancel() );
#endif

			LoadPrintersComboBox();
#if !DESIGN
			OnDialogControlChanged();
#endif
			


#if !DESIGN
			this.dtpStartDate.CustomFormat = this.dtpEndDate.CustomFormat = 
				Common.VBECSDateTime.DateFormat;

            //CR 3554
            if (_report == null)
                throw new ApplicationException("_report is null");

			this.dtpStartDate.Value = this._report.StartDate;
			this.dtpEndDate.Value = this._report.EndDate;
#endif
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgInappropriateRequestReportCriteria));
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picReportLogo = new System.Windows.Forms.PictureBox();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(394, 30);
			this.vbecsLogo1.Title = " Inappropriate Transfusion Request Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 264);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 40);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(328, 52);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(228, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 2;
			this.dtpEndDate.Value = new System.DateTime(2100, 1, 1, 23, 59, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.dtpEndDate_ValueChanged);
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(176, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(1900, 1, 1, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.dtpStartDate_ValueChanged);
			// 
			// grpImage
			// 
			this.grpImage.Controls.Add(this.picReportLogo);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 40);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 202);
			this.grpImage.TabIndex = 35;
			this.grpImage.TabStop = false;
			// 
			// picReportLogo
			// 
			this.picReportLogo.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picReportLogo.Image = ((System.Drawing.Image)(resources.GetObject("picReportLogo.Image")));
			this.picReportLogo.Location = new System.Drawing.Point(4, 12);
			this.picReportLogo.Name = "picReportLogo";
			this.picReportLogo.Size = new System.Drawing.Size(45, 45);
			this.picReportLogo.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picReportLogo.TabIndex = 0;
			this.picReportLogo.TabStop = false;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 96);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(326, 146);
			this.grpReportCompilation.TabIndex = 3;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 44);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 4;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.rdoScheduleJob_CheckedChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 4;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 44);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(310, 91);
			this.grpScheduleJob.TabIndex = 4;
			this.grpScheduleJob.TabStop = false;
			this.grpScheduleJob.Text = "grpScheduleJob";
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(206, 22);
			this.cmbPrinterName.TabIndex = 6;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.cmbPrinterName_SelectedIndexChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 13;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 11;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(206, 20);
			this.dtpPrintDate.TabIndex = 5;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.dtpPrintDate_ValueChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = System.Windows.Forms.AnchorStyles.Right;
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(232, 252);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 38;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = System.Windows.Forms.AnchorStyles.Right;
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(312, 252);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 39;
			this.btnCancel.Text = "&Cancel";
			// 
			// DlgInappropriateRequestReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(394, 280);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpDateRange);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Inappropriate_Transfusion_Request_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(400, 312);
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(400, 312);
			this.Name = "DlgInappropriateRequestReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS -  Inappropriate Transfusion Request Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.grpDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// GetReportObject
		/// </summary>
		/// <returns></returns>
		protected gov.va.med.vbecs.BOL.VbecsReport GetReportObject()
		{
			this._report = new BOL.InappropriateTransfusionRequestReport();
#if DEBUG
//			_report.StartDate = _report.StartDate.AddYears( -100 );
#endif
			return _report;
		}

		/// <summary>
		/// GetValidationMessage
		/// </summary>
		/// <returns></returns>
		/// <summary>
		/// GetValidationMessage
		/// </summary>
		/// <returns></returns>
		protected string GetValidationMessage()
		{
			return this._report.GetBrokenRulesMessage( VbecsBrokenRules.ProlongedTransfusionReport.FormClassName );
		}

		/// <summary>
		/// Get NumberOfRecordsPerReportPage
		/// </summary>
		protected int NumberOfRecordsPerReportPage
		{
			get
			{
				return 20;
			}
		}

		/// <summary>
		/// GetReportRecordCountEstimate
		/// </summary>
		/// <returns></returns>
		protected int GetReportRecordCountEstimate()
		{
			return this._report.GetRecordCountEstimate();
		}

		/// <summary>
		/// CheckWarnAboutZeroRecordsReturned
		/// </summary>
		/// <param name="recordsCount"></param>
		/// <returns></returns>
		protected bool CheckWarnAboutZeroRecordsReturned(int recordsCount)
		{
			return true; // There will be always some data in the report (divisional configuration). 
		}

		private void dtpStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.StartDate = dtpStartDate.Value;
			OnDialogControlChanged();
		}

		/// <summary>
		/// Should be called whenever any dialog control is changed to update state of OK button. 
		/// Call it from derived event handlers when needed.
		/// </summary>
		protected void OnDialogControlChanged()
		{
			btnOK.EnabledButton = _report.IsValid;
			btnOK.SetToolTip( _report.IsValid ? Common.StrRes.Tooltips.Common.OKToContinue().ResString : GetValidationMessage() );
		}

		private void LoadPrintersComboBox()
		{
			this.cmbPrinterName.Items.Clear();

			foreach( string _printerName in BOL.VbecsReport.GetPrinters() )
				cmbPrinterName.Items.Add( _printerName );
		}

		private void dtpEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.EndDate = dtpEndDate.Value;
			OnDialogControlChanged();
		}

		private void dtpPrintDate_ValueChanged(object sender, System.EventArgs e)
		{
			this._report.PrintDate=this.dtpPrintDate.Value;
			OnDialogControlChanged();
		}

		private void cmbPrinterName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._report.PrinterName=String.Empty;
			}
			OnDialogControlChanged();
		}

		private void rdoScheduleJob_CheckedChanged(object sender, System.EventArgs e)
		{
			this._report.IsScheduled = rdoScheduleJob.Checked;
			this.grpScheduleJob.Enabled=rdoScheduleJob.Checked;
			if(this.grpScheduleJob.Enabled)
			{
				this._report.PrintDate=this.dtpPrintDate.Value;
			}
			OnDialogControlChanged();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			bool ravenResult = false;
			ravenResult = CheckAdditionalBusinessRules();
			if(ravenResult== false)
			{
				this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
				return;
			}
			else
			{
				ShowAdditionalMessages();

				this.DialogResult = System.Windows.Forms.DialogResult.OK;
				this.Close();
			}
		}

		/// <summary>
		/// Override this method to check additional business rules / confirmations not handled 
		/// by broken rules in your report object.
		/// Make sure you call base implementation from yours - checks like 'scheduled report's date 
		/// range is greater than 30 days' and so on are done here.
		/// </summary>
		/// <returns>True if everything is valid and user confirmed everything.</returns>
		protected bool CheckAdditionalBusinessRules()
		{
			return CheckWarnAboutThirtyDaysScheduling() && RunReportRecordCountBasedChecks();
		}

		/// <summary>
		/// Performs record-count based checks( 'scheduled report's date range is greater than 30 days' et cetera).
		/// Override this method to return true if you want to disable the checks. 
		/// </summary>
		/// <returns>True if all record count based checks are OK.</returns>
		protected bool RunReportRecordCountBasedChecks()
		{
			//Don't perform checks if scheduled
			if (this._report.IsScheduled)
				return true;

			int _reportRecordCount;

			using( new WaitCursor() )
				_reportRecordCount = GetReportRecordCountEstimate();

			return
				CheckWarnAboutZeroRecordsReturned( _reportRecordCount ) &&
				CheckWarnAboutHeavyPageCount( _reportRecordCount ) && 
				CheckWarnAboutExtendedRecordCountBasedChecks( _reportRecordCount );
		}

		/// <summary>
		/// If report date range exceeds 30 days for scheduled report, the method asks user confirmation
		/// and returns false if user declines to proceed. Override this method to always return true if 
		/// you want to disable the check. 
		/// </summary>
		/// <returns>True if user confirms the choice, false otherwise.</returns>
		protected bool CheckWarnAboutThirtyDaysScheduling()
		{
			return 
				!this._report.IsScheduledReportGreaterThanThirtyDays ||
				this.DialogResult == GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays() );				
		}
		/// <summary>
		/// Does not do anything in base implementation, override it to perform extended record count based checks.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>Always returns true.</returns>
		protected bool CheckWarnAboutExtendedRecordCountBasedChecks( int recordsCount )
		{
			return true;
		}
		/// <summary>
		/// Checks if page count exceeds the threshold. If it does, user is asked to confirm his/her 
		/// choice of report criteria. If the user elects to proceed, the warning message is displayed
		/// saying that building a report may take a few minutes. 
		/// Override this method to always return true if you want to disable the check.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>False if record count exceeds the threshold and user cancelled the processing.</returns>
		protected bool CheckWarnAboutHeavyPageCount( int recordsCount )
		{
			if( recordsCount / NumberOfRecordsPerReportPage < ReportPageCountWarningThreshold )
				return true;

			if( this.DialogResult != GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.UC049.PageCountAlert() ) )
				return false;

			// Alert user that building report may take a few minutes
			GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC049.Warning() );
			return true;
		}

		/// <summary>
		/// Override this method in derived dialogs to display additional messages 
		/// before the dialog is closed (button OK clicked). 
		/// </summary>
		protected void ShowAdditionalMessages()
		{
		}


		/// <summary>
		/// Get InappropriateTransfusionRequestReport
		/// </summary>
		public InappropriateTransfusionRequestReport InappropriateTransfusionRequestReport
		{
			get
			{
				return this._report;
			}
		}
	}
}

